/*!
 * Brackets Git Extension
 *
 * @author Martin Zagora
 * @license http://opensource.org/licenses/MIT
 */

define(function (require, exports, module) {


    // Brackets modules
    var _               = brackets.getModule("thirdparty/lodash"),
        AppInit         = brackets.getModule("utils/AppInit"),
        ExtensionUtils  = brackets.getModule("utils/ExtensionUtils"),
        NodeConnection  = brackets.getModule("utils/NodeConnection");


    function loadExtension() {
        if(window.dwGitPanelInstance !== true && window.dwGitDialogInstance !== true) {
                 // Load CSS
                ExtensionUtils.loadStyleSheet(module, "styles/code-mirror.less");
                require(["src/DWGutterManager"], function(DWGutterManager) {
                    DWGutterManager.init();
                });
            }
        else {// Try to get Git version, if succeeds then Git works
            require(["src/utils/Setup"],function(Setup){
                Setup.findGit().then(function (version) {
                    ExtensionUtils.loadStyleSheet(module, "styles/brackets-git.less");
                    ExtensionUtils.loadStyleSheet(module, "styles/fonts/octicon.less");

                    require(["src/Main"],function(Main) {
                        Main.init(version);
                    });
                }).catch(function (err) {
                    if( window.dwGitPanelInstance === true) {
                        require(["src/DWGit/DWGitEvents"],function(DWGitEvents) {
                            dwbrackets.dwGitNotification(DWGitEvents.DW_GIT_INIT, "false");
                        });
                    }
                });

            });
        }
    }

    AppInit.htmlReady(function () {
        loadExtension();
    });

    var nodeDomains = {};

    // keeps a track of who is accessing node domains
    NodeConnection.prototype.loadDomains = _.wrap(NodeConnection.prototype.loadDomains, function (loadDomains) {

        var paths = arguments[1];
        if (!Array.isArray(paths)) { paths = [paths]; }

        var extId = "unknown";
        var stack = new Error().stack.split("\n").slice(2).join("\n");
        var m = stack.match(/extensions\/user\/([^\/]+)/);
        if (m) {
            extId = m[1];
        }

        if (!nodeDomains[extId]) { nodeDomains[extId] = []; }
        nodeDomains[extId] = _.uniq(nodeDomains[extId].concat(paths));

        // call the original method
        return loadDomains.apply(this, _.toArray(arguments).slice(1));
    });

});
